# 🚀 File-Rocket 2.0

<div align="center">

![File-Rocket Logo](https://img.shields.io/badge/File--Rocket-2.0-blueviolet?style=for-the-badge&logo=rocket)
[![Docker Image Version (latest by date)](https://img.shields.io/docker/v/lihupr/file-rocket?label=Docker%20Hub&style=flat-square&color=blue)](https://hub.docker.com/r/lihupr/file-rocket)
[![GitHub](https://img.shields.io/badge/GitHub-Lihu--PR-black?style=flat-square&logo=github)](https://github.com/Lihu-PR)

**新一代轻量级、高性能的异地大文件传输工具**  
专为 ARM64 嵌入式设备（如 OpenWrt 软路由、树莓派）优化，同时也完美支持 PC 和服务器。

### 🌐 在线体验
**[http://112.126.74.91:8888/](http://112.126.74.91:8888/)** - 立即体验，无需安装

*© 2025 File-Rocket • Designed for Speed*

</div>

## ✨ 核心特性

- 🔒 **安全传输**：端到端传输，服务器仅做中继，**不存储任何文件**。
- ⚡ **流式传输**：基于内存的流式转发，支持超大文件，速度仅受带宽限制。
- 🌐 **全平台支持**：提供 **ARM64** (OpenWrt/树莓派) 和 **AMD64** (PC/服务器) 镜像。
- 📱 **响应式设计**：全新的 Glassmorphism UI，完美适配手机、平板和电脑。
- 🎯 **极低占用**：内存占用极低，适合在路由器等低功耗设备上全天候运行。
- 🔄 **智能断连检测**：精准监测传输状态，异常断开秒级响应。

---

## 📦 部署指南 (Docker)

> 💡 **提示**：不想自己部署？直接访问 [在线体验地址](http://112.126.74.91:8888/) 试用！

我们强烈推荐直接使用 Docker 部署，这是最快、最稳定的方式。

### 1️⃣ 快速启动 (推荐)

根据您的设备类型选择命令：

#### 🏠 ARM64 设备 (OpenWrt / 树莓派 / 电视盒子)
```bash
docker run -d \
  --name file-rocket \
  --restart unless-stopped \
  -p 3000:3000 \
  --memory=128m \
  --cpus=0.3 \
  lihupr/file-rocket:arm64
```

#### 💻 AMD64 设备 (Windows / Linux PC / 云服务器)
```bash
docker run -d \
  --name file-rocket \
  --restart unless-stopped \
  -p 3000:3000 \
  lihupr/file-rocket:latest
```

> **访问地址**：打开浏览器访问 `http://设备IP:3000`

---

### 2️⃣ 自行构建镜像 (高级)

如果您需要修改源码或自行编译，请按以下步骤操作。

#### ⚠️ 编译前必读：网络问题解决
由于国内网络环境，构建时可能会拉取基础镜像失败。**请务必先手动拉取基础镜像到本地**：

**对于 ARM64 (构建给 OpenWrt/树莓派用):**
```bash
docker pull --platform linux/arm64 node:18-alpine
```

**对于 AMD64 (构建给 PC/服务器用):**
```bash
docker pull --platform linux/amd64 node:18-alpine
```

#### 🛠️ 构建步骤 (以 Windows 为例)

**构建 ARM64 镜像：**
```powershell
# 1. 确保已拉取基础镜像 (见上一步)
# 2. 执行构建命令
docker build --platform linux/arm64 -t file-rocket:arm64 .

# 3. 导出为文件 (方便传输到路由器)
docker save file-rocket:arm64 -o file-rocket-arm64.tar
```

**构建 AMD64 镜像：**
```powershell
# 1. 确保已拉取基础镜像
# 2. 执行构建命令
docker build --platform linux/amd64 -t file-rocket:amd64 .
```

---

## 🔧 使用说明

### 📤 发送文件
1. 打开首页，点击 **"发送文件"**。
2. 拖拽或选择文件。
3. 点击 **"生成取件码"**，获得 4 位取件码。
4. 将取件码发给对方，等待连接。

### 📥 接收文件
1. 打开首页，点击 **"接收文件"**。
2. 输入对方提供的 4 位取件码。
3. 确认文件信息无误后，点击 **"接收文件"** 开始下载。

---

## ❓ 常见问题 (FAQ)

**Q: 文件会保存在服务器上吗？**  
A: **不会**。File-Rocket 采用流式传输，数据从发送端通过内存直接流向接收端，服务器硬盘不保存任何文件数据。

**Q: 传输速度有多快？**  
A: 取决于发送端和接收端两边的**上传/下载带宽**以及服务器的中继带宽。

**Q: OpenWrt 部署报错 "exec format error"？**  
A: 您可能部署了 AMD64 的镜像。请确保使用 `lihupr/file-rocket:arm64` 标签。

**Q: 构建时报错 "failed to do request: EOF"？**  
A: 这是网络问题导致无法拉取基础镜像。请参考上文的 **"编译前必读"**，先使用 `docker pull` 手动拉取镜像。

---

## 🤝 贡献与反馈

欢迎提交 Issue 或 PR 改进项目。

- **GitHub**: [Lihu-PR](https://github.com/Lihu-PR)
- **Docker Hub**: [lihupr](https://hub.docker.com/u/lihupr)

---

<div align="center">
Made with ❤️ by Lihu-PR
</div>
